<?php
// CAPTCHA settings
$captcha_code = '';
$characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
$length = 6;
$width = 200;
$height = 60;
$font_size = 5; // A simple built-in font size
$noise_points = 500;
$noise_lines = 10;

// Generate a random CAPTCHA string
for ($i = 0; $i < $length; $i++) {
    $captcha_code .= $characters[rand(0, strlen($characters) - 1)];
}

// Store the code in the session for validation
$_SESSION['captcha_code'] = $captcha_code;

// Create a new image with a white background
$image = imagecreate($width, $height);
$bg_color = imagecolorallocate($image, 255, 255, 255);

// Set text and noise colors
$text_color = imagecolorallocate($image, 44, 44, 44);
$noise_color = imagecolorallocate($image, 150, 150, 150);

// Add random noise (dots)
for ($i = 0; $i < $noise_points; $i++) {
    imagesetpixel($image, rand(0, $width), rand(0, $height), $noise_color);
}

// Add random noise (lines)
for ($i = 0; $i < $noise_lines; $i++) {
    imageline($image, rand(0, $width), rand(0, $height), rand(0, $width), rand(0, $height), $noise_color);
}

// Position the text (simple, center-aligned)
$text_x = ($width - imagefontwidth($font_size) * strlen($captcha_code)) / 2;
$text_y = ($height - imagefontheight($font_size)) / 2;

// Draw the CAPTCHA string onto the image using the simpler function
imagestring($image, $font_size, $text_x, $text_y, $captcha_code, $text_color);

// Capture the image output as a base64 string
ob_start();
imagepng($image);
$imageData = ob_get_contents();
ob_end_clean();

// Output the base64 encoded image data
echo base64_encode($imageData);

// Free up memory
imagedestroy($image);
